Attribute VB_Name = "ConvertData"
Option Explicit


Function CheckDestinationTable(strFN As String, intDBType As Integer, strTable As String) As Boolean

    On Error GoTo Err_CT
    
    'verify that file and/or table does not already exist
    'prompt user for how to handle existing files/tables

    Dim i As Integer
    Dim cat As New adox.Catalog
    Dim strMsg As String
    Dim strConn As String

    If Trim$(strFN) = "" Then Exit Function
    
    If FileExist(strFN) = True Then
        Select Case intDBType
        Case 0, 4 'Certain databases may have existing tables
            If (intDBType = 0) Then 'Access DB
                strConn = "Provider=Microsoft.Jet.OLEDB.4.0;" & _
                    "Data Source=" & strFN & ";" & _
                    "Jet OLEDB:Engine Type=4;"
            Else 'Excel files
                strConn = "Provider=" & _
                    "Microsoft.Jet.OLEDB.4.0;" & _
                    "Data Source=" & strFN & ";" & _
                    "Extended Properties=Excel 8.0;"
            End If
            
            'set the catalog connection
            cat.ActiveConnection = strConn
            For i = 0 To cat.Tables.Count - 1
                If Trim$(UCase(cat.Tables(i).Name)) = Trim$(UCase(strTable)) Then
                    strMsg = "The table [" & strTable & "] already exists in " & _
                        "the database [" & strFN & "]. If you continue, the table " & _
                        "will be OVERWRITTEN." & vbCrLf & vbCrLf & "Are you sure " & _
                        "you want to continue?"
                    If MsgBox(strMsg, vbQuestion + vbYesNo, "Confirm Table Deletion...") = vbNo Then
                        Exit Function
                    Else 'delete the table
                        cat.Tables.Delete i
                        Exit For
                    End If
                End If
            Next i
        Case Else 'Verify that file does not already exist
            strMsg = "The database/file [" & strFN & _
                "] already exists. If you continue, " & _
                "the file will be OVERWRITTEN." & _
                vbCrLf & vbCrLf & "Are you sure you want " & _
                "to continue?"
            If MsgBox(strMsg, vbQuestion + vbYesNo, "Confirm File Delete...") = vbNo Then
                Exit Function
            Else 'delete the file
                Kill strFN
            End If
        End Select
    End If
    
    CheckDestinationTable = True
    
Exit_CT:
    Exit Function
    
Err_CT:
    Err.Raise Err.Number, Err.Source, Err.Description
    Err.Clear

End Function

Function ConvertDatabase(strConnection As String, strSQL As String) _
    As Boolean

    On Error GoTo Err_CD

    'convert one database format to another
    'requires that procedures [GetSourceConnectionString]
    'and [GetSQLConvertString] have been called prior
    
    Dim Conn As New ADODB.Connection
    
    Screen.MousePointer = vbHourglass
    
    Conn.Open strConnection
    Conn.Execute strSQL
    
    'Debug.Print strConnection
    'Debug.Print strSQL
    Screen.MousePointer = vbDefault
    ConvertDatabase = True

Exit_CD:
    Conn.Close
    Set Conn = Nothing
    Exit Function
    
Err_CD:
    'Debug.Print strConnection
    'Debug.Print strSQL
    Beep
'    Err.Raise Err.Number, Err.Source, Err.Description
'    Err.Clear

End Function
Function FolderExist(strDir As String) As Boolean

    'determine if a folder exists

    Dim fso

    Set fso = CreateObject("Scripting.FileSystemObject")
    
    FolderExist = fso.FolderExists(strDir)

End Function

Function FileExist(strFile As String) As Boolean

    'determine if a file exists

    Dim fso

    Set fso = CreateObject("Scripting.FileSystemObject")
    
    FileExist = fso.FileExists(strFile)

End Function



Function GetSourceConnectionString(strFN As String, intDBType As Integer, _
    strTable As String, strTableFrom As String) As String

    'return the ADO connection string for the passed information
    'also return the SQL for the "FROM" clause
    
    Dim strMsg As String
    Dim strPath As String
    
    If FileExist(strFN) <> True Then
        strMsg = "Invalid filename [" & strFN & "]... Cannot convert database..."
        MsgBox strMsg, vbExclamation, "Invalid FileName..."
        Exit Function
    End If
    
    strPath = GetPathName(strFN)
    
    Select Case intDBType
    Case 0 'Access 2000
        GetSourceConnectionString = "Provider=" & _
            "Microsoft.Jet.OLEDB.4.0;" & _
            "Data Source=" & strFN & ";" & _
            "Jet OLEDB:Engine Type=4;"
        strTableFrom = "[" & strTable & "]"
    Case 1 'dBase III
        GetSourceConnectionString = "Provider=MSDASQL.1;" & _
            "Extended Properties=;DRIVER=" & _
            "Microsoft dBase Driver (*.dbf);" & _
            "DefaultDir=" & strPath & ";DriverId=21;" & _
            "FIL=dBase III;MaxBufferSize=2048;" & _
            "PageTimeout=600;UID=admin;"
        strTableFrom = "[" & GetBaseName(strFN) & "]"
    Case 2 'dBase IV
        GetSourceConnectionString = "Provider=MSDASQL.1;" & _
            "Extended Properties=;DRIVER=" & _
            "Microsoft dBase Driver (*.dbf);" & _
            "DefaultDir=" & strPath & ";DriverId=21;" & _
            "FIL=dBase IV;MaxBufferSize=2048;" & _
            "PageTimeout=600;UID=admin;"
        strTableFrom = "[" & GetBaseName(strFN) & "]"
    Case 3 'dBase V
        GetSourceConnectionString = "Provider=MSDASQL.1;" & _
            "Extended Properties=;DRIVER=" & _
            "Microsoft dBase Driver (*.dbf);" & _
            "DefaultDir=" & strPath & ";DriverId=21;" & _
            "FIL=dBase V;MaxBufferSize=2048;" & _
            "PageTimeout=600;UID=admin;"
        strTableFrom = "[" & GetBaseName(strFN) & "]"
    Case 4 'Excel 2000
        GetSourceConnectionString = "Provider=" & _
            "Microsoft.Jet.OLEDB.4.0;" & _
            "Data Source=" & strFN & ";" & _
            "Extended Properties=Excel 8.0;"
        strTableFrom = "[" & strTable & "]"
    Case 5 'HTML
        GetSourceConnectionString = "Provider=" & _
            "Microsoft.Jet.OLEDB.4.0;" & _
            "Data Source=" & strFN & ";" & _
            "Extended Properties=HTML Import;"
        strTableFrom = "[" & GetBaseName(strFN) & "]"
    Case 6 'Text
        GetSourceConnectionString = "Driver={Microsoft Text Driver " & _
            "(*.txt; *.csv)};DBQ=" & strPath & _
            ";DefaultDir=" & strPath & ";Uid=Admin;Pwd=;"
        strTableFrom = "[" & GetFileName(strFN) & "]"
    End Select

End Function
Function GetSQLConvertString(strFN As String, intDBType As Integer, _
    strTable As String, strFromTable As String) As String

    'return the SQL string for the passed criteria
    'this will be used with the ADO connection string
    
    Dim strPath As String
    Dim strBase As String
    Dim strFile As String
    Dim strSQL As String
    
    strPath = GetPathName(strFN)
    strBase = GetBaseName(strFN)
    strFile = GetFileName(strFN)
    
    strSQL = "SELECT * INTO "
    
    Select Case intDBType
    Case 0 'Access 2000
            strSQL = strSQL & "[" & strTable & _
                "] IN '" & strFN & "'"
    Case 2 'dBase III
            strSQL = strSQL & "[" & strBase & _
                "] IN '" & strPath & "' 'dBase III;'"
    Case 3 'dBase IV
            strSQL = strSQL & "[" & strBase & _
                "] IN '" & strPath & "' 'dBase IV;'"
    Case 4 'dBase V
            strSQL = strSQL & "[" & strBase & _
                "] IN '" & strPath & "' 'dBase 5.0;'"
    Case 5 'Excel
            strSQL = strSQL & "[" & strTable & _
                "] IN '" & strFN & "' 'Excel 8.0;'"
    Case 6 'HTML
            strSQL = strSQL & "[" & strFile & _
                "] IN '" & strPath & "' 'HTML Export;'"
    Case 1, 7 'Text, csv
            strSQL = strSQL & "[" & strFile & _
                "] IN '" & strPath & "' 'Text;'"
    End Select
    
    GetSQLConvertString = strSQL & " FROM " & strFromTable

End Function
Sub LoadTables(strFN As String, intDBType As Integer, _
    ctrlCombo As ComboBox)

    On Error GoTo Err_LT

    'load the tables for an Access DB or Excel Spreadsheet

    Dim i As Integer
    Dim cat As New adox.Catalog
    Dim strMsg As String
    Dim strConn As String
    
    If Trim$(strFN) = "" Then Exit Sub
    
    If FileExist(strFN) <> True Then
        If (intDBType = 0) Then 'Access DB
            strMsg = "The file [" & strFN & "] does not seem to " & _
                "be a valid filename." & vbCrLf & vbCrLf & _
                "Please select a valid file before continuing..."
            MsgBox strMsg, vbExclamation, "Invalid FileName..."
        End If
        Exit Sub
    End If
    
    If (intDBType = 0) Then 'Access DB
        strConn = "Provider=Microsoft.Jet.OLEDB.4.0;" & _
            "Data Source=" & strFN & ";" & _
            "Jet OLEDB:Engine Type=4;"
    ElseIf (intDBType = 4) Then 'Excel Spreadsheet
        strConn = "Provider=" & _
            "Microsoft.Jet.OLEDB.4.0;" & _
            "Data Source=" & strFN & ";" & _
            "Extended Properties=Excel 8.0;"
    End If
                     
    'open a catalog connection to the database
    cat.ActiveConnection = strConn
    
    'return the table names
    ctrlCombo.Clear
    For i = 0 To cat.Tables.Count - 1
        ctrlCombo.AddItem Trim$(cat.Tables(i).Name)
    Next i
    
Exit_LT:
    Exit Sub
    
Err_LT:
    Err.Raise Err.Number, Err.Source, Err.Description
    Err.Clear
    
End Sub
Function GetPathName(strFile As String) As String

    'return the path for a file (folder only)
    
    Dim fso

    Set fso = CreateObject("Scripting.FileSystemObject")
    
    GetPathName = fso.GetParentFolderName(strFile)

End Function


Function GetBaseName(strFile As String) As String

    'return the base filename (minus extension) for a folder
    
    Dim fso

    Set fso = CreateObject("Scripting.FileSystemObject")
    
    GetBaseName = fso.GetBaseName(strFile)

End Function


Function GetFileName(strFile As String) As String

    'return the file for a folder
    
    Dim fso

    Set fso = CreateObject("Scripting.FileSystemObject")
    
    GetFileName = fso.GetFileName(strFile)
    
End Function


